jQuery(document).ready(function() {
		
	var currentGallery, disableLinks = false;
	
	jQuery("select").uniform();
	
	//init sortable for album list
	jQuery("#albumList").sortable();
	//jQuery("#albumList").disableSelection();
	
	//global ajax error handler
	jQuery(document).ajaxError(function() {
		toggleAjaxLoading();
	});
	
	jQuery('#gallerySelecter').change(function() {

		jQuery('#albumList').empty();
		currentGallery = jQuery('#gallerySelecter').val();
		if(!currentGallery) {
			
			alert("You have created no galleries yet. Please create an gallery first!\nYou will be redirected to the 'Manage galleries' page.");
			location.href = 'admin.php?page=fancy-gallery';
			return false;
		}
		
		toggleAjaxLoading();
				
		jQuery.ajax({ url: options.Ajax_Url, data: { action: 'loadalbums', gallery: currentGallery }, type: 'post', success: function(data) {
			if(data.length == 0) {
				jQuery('#albumList').append("<p>No albums created yet for this gallery!</p>");
			}
			else {
			  jQuery.each(data, function() {
				  jQuery('#albumList').append('<li><div class="dragIcon"></div><input value="'+ stripslashes(this.title) +'" type="text" name="albumTitles[]" readonly="readonly" /><a class="edit" href="#" title="Edit album title"></a><a class="delete" href="#" title="Delete album"></a></li>');
			  });
			}
			toggleAjaxLoading();
			showSuccessBox('Albums successfully loaded!');
			
		  }
		});
	}).change();
	
	//add a new album to the album list
	jQuery('#addNewAlbum').click(function() {
		
		var titleInput =  jQuery('input[name=album_title]');
		if(titleInput.val() != "") {
            toggleAjaxLoading();
			jQuery.ajax({ url: options.Ajax_Url, data: { action: 'newalbum', gallery: currentGallery, title: titleInput.val(), sortId: jQuery('#albumList li').size() }, type: 'post', success: function(data) {
				//save response
				var res = wpAjax.parseAjaxResponse(data, 'ajax-response');
				var msg = getResponseMessage(res);
				
                if(jQuery('#albumList').children('li').size() == 0) {
					jQuery('#albumList').empty();
				}
				if(!res.errors) {
					jQuery('#albumList').append('<li><div class="dragIcon"></div><input value="'+ titleInput.val() + '" type="text" name="albumTitles[]" readonly="readonly" /><a class="edit" href="#" title="Edit album title"></a><a class="delete" href="#" title="Delete album"></a></li>');
					titleInput.val('');
					showSuccessBox(msg);
				}
				else {
					alert(msg);  
				}
				
				toggleAjaxLoading();
			  }
			});
		}
		else {
			alert("Please enter an album title");
		}
		
		return false;
	});
	
	//edit a track from the playlist
	jQuery('#albumList li .edit').live('click', function(evt){

		if(disableLinks) {
			return false;
		}
		
		var item = jQuery(evt.currentTarget).parent();
		var oldTitle = item.find('input').val();
		var newTitle = prompt("Please enter a title:", oldTitle);
		
		if(newTitle == null || oldTitle == newTitle) {
			return false;	
		}
		
		if(newTitle != '') {
			toggleAjaxLoading();
			jQuery.ajax({ url: options.Ajax_Url, data: { action: 'editalbum', gallery: currentGallery, oldTitle: oldTitle, newTitle: newTitle }, type: 'post', success: function(data) {
				var res = wpAjax.parseAjaxResponse(data, 'ajax-response');
				var msg = getResponseMessage(res);
				
				if(!res.errors) {
					item.find('input').val(newTitle);
					showSuccessBox(msg);
				}
				else {
					alert(msg);
				}	
				
				toggleAjaxLoading();
			  }
			});
		}
		else {
			alert("You can not set an empty title!");	
		}
		
		return false;
	});
	
	//delete a track from the playlist
	jQuery('#albumList li .delete').live('click', function(evt){
		
		if(disableLinks) {
			return false;
		}
		
		var item = jQuery(evt.currentTarget).parent();
		var r = confirm("You are going to delete the album: "+ item.find('input').val() +".\nAll images inside the album will be also deleted!\n\nAre you sure?");
		if(r) {
			toggleAjaxLoading();
			jQuery.ajax({ url: options.Ajax_Url, data: { action: 'deletealbum', gallery: currentGallery, title: item.find('input').val() }, type: 'post', success: function(data) {
				var res = wpAjax.parseAjaxResponse(data, 'ajax-response');
				var msg = getResponseMessage(res);
				
				item.remove();
				
				if(!res.errors) {
					showSuccessBox(msg);
				}
				else {
					alert(msg);
				}

				toggleAjaxLoading();
			  }
			});
		}
		
		return false;
	});
	
	jQuery('#deleteAlbums').click(function() {
		
		if(jQuery('#albumList').children().size() == 0) {
			alert('You have no albums to delete!');
			return false;	
		}
		
		var r = confirm("You are going to delete all albums.\nAll images inside the albums will be also deleted!\n\nAre you sure?");
		
		if(r) {
			toggleAjaxLoading();

			jQuery.ajax({ url: options.Ajax_Url, data: { action: 'deletealbums', gallery: currentGallery }, type: 'post', success: function(data) {
				var res = wpAjax.parseAjaxResponse(data, 'ajax-response');
				var msg = getResponseMessage(res);

				if(!res.errors) {
					jQuery('#albumList').empty();
					showSuccessBox(msg);
				}
				else {
					alert(msg);
				}
	  
				toggleAjaxLoading();
			  }
			});
		}

		return false;
	});
	
	jQuery('#updateAlbums').click(function() {
				
		toggleAjaxLoading();
		
		var albums = jQuery('input[name*=albumTitles]').serializeArray();			
		jQuery.ajax({ url: options.Ajax_Url, data: { action: 'updatealbums', gallery: currentGallery, albums: albums }, type: 'post', success: function(data) {
			var res = wpAjax.parseAjaxResponse(data, 'ajax-response');
			var msg = getResponseMessage(res);
			
			if(!res.errors) {
				showSuccessBox(msg);
			}
			else {
				alert(msg);
			}
			
			toggleAjaxLoading();			
		  }
		});
		
		return false;
	});
	
	//disable all links
	if(jQuery(document).find('.fg-disable-links').length) {
		disableLinks = true;
		jQuery('.fg-disable-links').find('object, .button-secondary, .button-primary').unbind().die().fadeTo(0, 0.5);
		jQuery('.fg-disable-links').find('input:submit').attr('disabled', 'disabled');
		return false;
	};
	
	function stripslashes(str) {
		str=str.replace(/\\'/g,'\'');
		str=str.replace(/\\"/g,'"');
		str=str.replace(/\\0/g,'\0');
		str=str.replace(/\\\\/g,'\\');
		return str;
	};
});