<?php get_header() ?>

	<?php locate_template( array( 'sidebar-home-left.php' ), true ) ?>
							
		<!-- When homepage is using blog posts -->
		<?php if ( is_home() ) : ?>		
				
				<?php do_action( 'bp_before_blog_page' ) ?>	
				
				<div id="content" class="three_column">
				<div class="padder">
					<div class="page" id="blog-page">
					
					<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
		
						<div class="post" id="post-<?php the_ID(); ?>">
						
									<h1 class="posttitle"><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php _e( 'Permanent Link to', 'buddypress' ) ?> <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h1>
				
									<p class="date"><?php the_date('M j, Y') ?> at <?php the_time() ?> <?php _e( 'in', 'buddypress' ) ?> <?php the_category(', ') ?> <?php printf( __( 'by %s', 'buddypress' ), bp_core_get_userlink( $post->post_author ) ) ?> &middot; <span class="tags"><?php the_tags( __( 'Tags: ', 'buddypress' ), ', ', '<br />'); ?></span> <?php if ('open' == $post->comment_status): ?><span class="comments"><?php comments_popup_link( __( 'Leave a Comment &#187;', 'buddypress' ), __( '1 Comment &#187;', 'buddypress' ), __( '% Comments &#187;', 'buddypress' ) ); ?></span><?php else : ?><?php _e('Comments are closed.', 'buddypress'); ?><?php endif; ?></p>
			
									<div class="entry">
										<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('thumbnail');?></a>
								
										<?php the_excerpt( __( 'Read the rest of this entry &rarr;', 'buddypress' ) ); ?>
			
										<?php wp_link_pages(array('before' => __( '<p><strong>Pages:</strong> ', 'buddypress' ), 'after' => '</p>', 'next_or_number' => 'number')); ?>
									</div>
										
							</div>
							
						<?php endwhile; ?>

							<div class="navigation">
			
								<div class="alignleft"><?php next_posts_link( __( '&larr; Previous Entries', 'buddypress' ) ) ?></div>
								<div class="alignright"><?php previous_posts_link( __( 'Next Entries &rarr;', 'buddypress' ) ) ?></div>
			
							</div>
			
						<?php else : ?>
			
							<h2 class="center"><?php _e( 'Not Found', 'buddypress' ) ?></h2>
							<p class="center"><?php _e( 'Sorry, but you are looking for something that isn\'t here.', 'buddypress' ) ?></p>
			
							<?php locate_template( array( 'searchform.php' ), true ) ?>
			
						<?php endif; ?>

						
						</div><!-- .page -->
					</div><!-- .padder -->
					</div><!-- #content -->
					
				<?php do_action( 'bp_after_blog_page' ) ?>
				<?php locate_template( array( 'sidebar-home-right.php' ), true ) ?>							
		
		<!-- When homepage is using Activity -->	
		<?php elseif ( 'activity' == bp_dtheme_page_on_front() && bp_is_active( 'activity' ) ): ?>		
			
				<div id="content" class="two_column_left">
				<div class="padder">
				
					<?php if ( is_user_logged_in() ) : ?>
						<?php locate_template( array( 'activity/post-form.php'), true ) ?>
					<?php endif; ?>
					
					<div class="item-list-tabs activity-type-tabs">
						<ul>
							<?php do_action( 'bp_before_activity_type_tab_all' ) ?>
		
							<li class="selected" id="activity-all"><a href="<?php echo bp_loggedin_user_domain() . BP_ACTIVITY_SLUG . '/' ?>" title="<?php _e( 'The public activity for everyone on this site.', 'buddypress' ) ?>"><?php printf( __( 'All Members (%s)', 'buddypress' ), bp_get_total_site_member_count() ) ?></a></li>
		
							<?php if ( is_user_logged_in() ) : ?>
		
								<?php do_action( 'bp_before_activity_type_tab_friends' ) ?>
		
								<?php if ( function_exists( 'bp_get_total_friend_count' ) ) : ?>
									<?php if ( bp_get_total_friend_count( bp_loggedin_user_id() ) ) : ?>
										<li id="activity-friends"><a href="<?php echo bp_loggedin_user_domain() . BP_ACTIVITY_SLUG . '/' . BP_FRIENDS_SLUG . '/' ?>" title="<?php _e( 'The activity of my friends only.', 'buddypress' ) ?>"><?php printf( __( 'My Friends (%s)', 'buddypress' ), bp_get_total_friend_count( bp_loggedin_user_id() ) ) ?></a></li>
									<?php endif; ?>
								<?php endif; ?>
		
								<?php do_action( 'bp_before_activity_type_tab_groups' ) ?>
		
								<?php if ( function_exists( 'bp_get_total_group_count_for_user' ) ) : ?>
									<?php if ( bp_get_total_group_count_for_user( bp_loggedin_user_id() ) ) : ?>
										<li id="activity-groups"><a href="<?php echo bp_loggedin_user_domain() . BP_ACTIVITY_SLUG . '/' . BP_GROUPS_SLUG . '/' ?>" title="<?php _e( 'The activity of groups I am a member of.', 'buddypress' ) ?>"><?php printf( __( 'My Groups (%s)', 'buddypress' ), bp_get_total_group_count_for_user( bp_loggedin_user_id() ) ) ?></a></li>
									<?php endif; ?>
								<?php endif; ?>
		
								<?php do_action( 'bp_before_activity_type_tab_favorites' ) ?>
		
								<?php if ( bp_get_total_favorite_count_for_user( bp_loggedin_user_id() ) ) : ?>
									<li id="activity-favorites"><a href="<?php echo bp_loggedin_user_domain() . BP_ACTIVITY_SLUG . '/favorites/' ?>" title="<?php _e( "The activity I've marked as a favorite.", 'buddypress' ) ?>"><?php printf( __( 'My Favorites (<span>%s</span>)', 'buddypress' ), bp_get_total_favorite_count_for_user( bp_loggedin_user_id() ) ) ?></a></li>
								<?php endif; ?>
		
							<?php endif; ?>
		
							<?php do_action( 'bp_activity_syndication_options' ) ?>
		
							<li id="activity-filter-select" class="last">
								<select>
									<option value="-1"><?php _e( 'No Filter', 'buddypress' ) ?></option>
									<option value="activity_update"><?php _e( 'Show Updates', 'buddypress' ) ?></option>
		
									<?php if ( bp_is_active( 'blogs' ) ) : ?>
										<option value="new_blog_post"><?php _e( 'Show Blog Posts', 'buddypress' ) ?></option>
										<option value="new_blog_comment"><?php _e( 'Show Blog Comments', 'buddypress' ) ?></option>
									<?php endif; ?>
		
									<?php if ( bp_is_active( 'forums' ) ) : ?>
										<option value="new_forum_topic"><?php _e( 'Show New Forum Topics', 'buddypress' ) ?></option>
										<option value="new_forum_post"><?php _e( 'Show Forum Replies', 'buddypress' ) ?></option>
									<?php endif; ?>
		
									<?php if ( bp_is_active( 'groups' ) ) : ?>
										<option value="created_group"><?php _e( 'Show New Groups', 'buddypress' ) ?></option>
										<option value="joined_group"><?php _e( 'Show New Group Memberships', 'buddypress' ) ?></option>
									<?php endif; ?>
		
									<?php if ( bp_is_active( 'friends' ) ) : ?>
										<option value="friendship_accepted,friendship_created"><?php _e( 'Show Friendship Connections', 'buddypress' ) ?></option>
									<?php endif; ?>
		
									<option value="new_member"><?php _e( 'Show New Members', 'buddypress' ) ?></option>
		
									<?php do_action( 'bp_activity_filter_options' ) ?>
								</select>
							</li>
		
							<?php do_action( 'bp_activity_type_tabs' ) ?>
						</ul>
					</div><!-- .item-list-tabs -->
					
					<div class="activity">
						<?php locate_template( array( 'activity/activity-loop.php' ), true ) ?>
					</div><!-- .activity -->
					
				</div><!-- .padder -->
				</div><!-- #content -->
												
							
		<!-- When homepage is using a regular Page -->	
		<?php else : ?>

			<div id="content" class="three_column">
			<div class="padder">
				<div class="page">
				
				<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
				
					<h1 class="pagetitle"><?php the_title(); ?></h1>
	
					<div class="post" id="post-<?php the_ID(); ?>">
	
						<div class="entry">
	
							<?php the_content( __( '<p class="serif">Read the rest of this page &rarr;</p>', 'buddypress' ) ); ?>
	
							<?php wp_link_pages( array( 'before' => __( '<p><strong>Pages:</strong> ', 'buddypress' ), 'after' => '</p>', 'next_or_number' => 'number')); ?>
	
						</div>
	
					</div>
	
				<?php endwhile; endif; ?>	
				
				</div><!-- .page -->	
			</div><!-- .padder -->
			</div><!-- #content -->
			
			<?php locate_template( array( 'sidebar-home-right.php' ), true ) ?>							
			
	<?php endif; ?>

<?php get_footer(); ?>
