<?php 

/**
* buddy_boss_wall is a BuddyPress plugin combining user activity feeds into a Facebook  
* like wall allowing to merge chosen activity feeds. It also allows to remove the "@mention" tab.
*
* @author: BuddyBoss
* @version: 1.0
* @package
*
* Credits
*
* r-a-y for the base of @mention removal
* brajesh for the tutorial on in profile posting

*/


// Indicate whether the Wall module is enabled
// Check if the friends module is enabled if not disable the wall
if (function_exists('friends_get_alphabetically'))
	{
		$option = get_option("buddy_boss_wall_on");		
		define(BUDDY_BOSS_WALL_ENABLED, $option);
	}
	else 
		{
			define(BUDDY_BOSS_WALL_ENABLED, FALSE);
		}


// Indicate whether to show debug msgs on screen 

define(BUDDY_BOSS_WALL_DEBUG, FALSE);

// a variable to hold he event log
$buddy_boss_debug_log = "";


// DEFAULT CONFIGURATION OPTIONS
$buddy_boss_wall_defaults = array("REMOVE_MENTIONS" => TRUE, 
						  
						   "POST_IN_WIRE_OPTIONS" => array(),
						 // 
						  "UPDATE_MENUS" =>TRUE,
						  "MENU_NAME" => "Wall");
						  
				


 class BuddyBoss_Wall 
{
	public $activities;
	private $options;
	public $activity_count = 0;
	public $filter_qa = false;
	function __construct($options = null)
	
	{
		global $buddy_boss_wall_defaults,  $activity_template; 
		
		
		if (isset($options) && $options !=null) 
			 {
			 $this->options = $options;
			 }
			 	else 
			 {
			 	$this->options = $buddy_boss_wall_defaults;
			 	buddy_boss_log("WALL Using default config");
			 	
			 }				 
			 
			 	buddy_boss_log($this->options);
			 	
			 if (isset($this->options["REMOVE_MENTIONS"])  && 
			 	$this->options["REMOVE_MENTIONS"] == TRUE)
			 	{
			 		$this->remove_mentions();
			 	
			 	}
			 	
			 	if (isset($this->options['UPDATE_MENUS']) && $this->options['UPDATE_MENUS'] == true) 
			 	{
			 		$this->update_menus();
			 		
			 	}
		
		

	}

	 function  remove_mentions()
	 {
	 
	 	// only enable no mentions if activity is enabled
	 	if (!bp_is_active('activity')) return;
	 	
		buddy_boss_log(" WALL removing mentions");
		$bpnm = new BP_No_Mentions();	 
		$bpnm -> init();
	 }
	 
	
	function get_option($name)
	{
		if (isset($this->options[$name])) return $this->options[$name];
		return false;
		
	}
	
	
	
	
	function update_menus()
	{
			buddy_boss_log('Updating Menus');
			global $bp;		
//			bp_core_remove_subnav_item( 'activity', 'friends');
			bp_core_remove_subnav_item( 'activity', 'groups');
			bp_core_remove_subnav_item( 'activity', 'favorites');
			bp_core_remove_subnav_item( 'activity', 'mentions');
			 
			

		$domain = (!empty($bp->displayed_user->id)) ? $bp->displayed_user->domain : $bp->loggedin_user->domain;
		$profile_link = $domain . $bp->activity->slug . '/';
		
		/* Rename Personal to wall */
		
		
			bp_core_new_subnav_item( array( 'name' => $this->options["MENU_NAME"], 'slug' => 'just-me', 'parent_url' => $profile_link, 'parent_slug' => $bp->activity->slug, 'screen_function' => 'bp_activity_screen_my_activity' , "position" => 10 ) );
	
		do_action('remove_merged_menus');

			add_action( 'bp_setup_nav', 'remove_merged_menus', 15 );

		
	}
	
	
function is_friend($id)
	{
		global $bp;
		$current_user_id = $bp->loggedin_user->id;
		$friends = friends_get_alphabetically($current_user_id) ;
		if (!isset($friends['users'])) return FALSE;
		
		foreach ($friends['users'] as $f) {
			
			if ($f->id == $id) return TRUE;
		}
		
		return FALSE;
	}



function get_wall_activities($page = 0, $per_page=20){
	
	global $bp,$wpdb;
	$min = ($page>0)? ($page-1) * $per_page : 0;
	$max = ($page+1) * $per_page;
	$per_page = bp_get_activity_per_page();
	buddy_boss_log(" per page $per_page");
	
	
	$wpdb->show_errors = BUDDY_BOSS_WALL_DEBUG;
	$user_id = $bp->displayed_user->id;
	
	buddy_boss_log("Looking at $user_id" );
	$filter = addslashes($bp->displayed_user->fullname);
	    $friend_ids = friends_get_friend_user_ids($user_id);
	   // var_dump($friend_ids);
					buddy_boss_log($friend_ids);
										
		if (!empty($friend_ids)) $friend_id_list = implode(",", ($friend_ids));
		
		buddy_boss_log($friend_id_list);
		$table = $wpdb->prefix."bp_activity";
		
		/* Group Display code */
		
			$groups = BP_Groups_Member::get_group_ids($user_id);
		//var_dump($groups);
		
		$valid_groups=array();
		if (!empty($groups)) {
			foreach ($groups['groups'] as $id)
			{
			 $group = new BP_Groups_Group( $id);
			// var_dump($group);
					 if ("public" == $group->status) {
					 //echo $group->slug;
					 $valid_groups[]=$id;
					
					 }		
			}
		}
			 $valid_group_list = implode(",",$valid_groups);
			// echo $valid_group_list;
		 	 $group_modifier =  (!empty($valid_group_list)) ? " (component='groups' AND item_id IN ($valid_group_list))" : "";
		//echo $group_modifier;
	
	
		
		/* (component='activity' AND type!='activity_comment' 
		AND user_id = $id) OR (user_id  in ($friend_id_list) 
		AND action LIKE '%$filter% wall%'  ) $group_modifier
		
		ORDER BY date_recorded DESC LIMIT $min, $max */
	
	
	    
		
		$qry = "SELECT id FROM $table WHERE (( component ='activity' AND user_id = $user_id AND type!='activity_comment')  OR (component = 'activity' AND user_id IN ($friend_id_list) AND 
		action LIKE '%$filter% wall%') ) OR $group_modifier 
		ORDER BY date_recorded DESC LIMIT $min, $max";
		
		
		
		$activities  = $wpdb->get_results($qry,ARRAY_A);
		//var_dump($wpdb->print_error());
		buddy_boss_log($qry);
		
		buddy_boss_log($activities);
		
			if (empty($activities )) return null;
 			
			
			$tmp = array();
			
			foreach ($activities as $a)
				{
					$tmp[] = $a["id"];
									
				}
		
				$activity_list = implode(",", $tmp);
		return $activity_list;
		
	
		
	}
	
	
} // end of BUDDY_BOSS_WALL class



// ACTIVATION AND DEACTIVATION CODE

function buddy_boss_wall_on_activate()
{
} 

function buddy_boss_wall_on_deactivate()
{
	global $wpdb, $bp;
	
	// lets get all the activities that have *wall in their action
	
	$qry = "SELECT * FROM wp_bp_activity WHERE action LIKE '%wall'";
	$affected = $wpdb->get_results($qry,ARRAY_A);
	
	echo count($affected)." wall entries will be converted to @mentions<br>";
	
	foreach ($affected as $a)
		{
			echo $a['action']."<br>";
			$old = $a['action'];
			
			
			$new =  preg_replace("/wrote \w+ /", " posted an update",$old);
			echo "after<br>";
			echo $new;
		}
	
} 


/* FILTERS */
if (BUDDY_BOSS_WALL_ENABLED)
	{
add_filter('bp_activity_new_update_action', 'wall_activity_filter');
add_filter('bp_activity_new_update_content', 'wall_content_filter');
 add_filter('bp_ajax_querystring', 'wall_qs_filter');
}




function wall_activity_filter($activity)
	{
		global $bp, $buddy_boss_wall;
	
		
			
		$user = $bp->loggedin_user;
		
		$tgt  = $bp->displayed_user;
		
		if (!isset($tgt->id) || ($user->id == $tgt->id)) return $activity;
		
		$user_url  = "<a href=
		\" $user->domain\">$user->fullname</a>";
		
		
		$tgt_url  = "<a href=
		\" $tgt->domain\">$tgt->fullname's</a>";
	
		// if a user is on his own page it is an update			
		
		return $user_url. " wrote on ". $tgt_url." wall";
	}	


function wall_content_filter($content)
	{
	
		// remove add mentions
		if (!preg_match('/@\w+\s/', $content)) return $content;
		
		return preg_replace('/@\w+\s/','',$content);	
	}
	


function wall_qs_filter($qs)
	{
		global $bp, $buddy_boss_wall;
		
		//echo $qs;
		$action =$bp->current_action;
		if ( $action != "just-me") 
		{
			// if we're on a different page than wall pass qs as is
			return $qs;
		}
		// else modify it to include wall activities
	
		// see if we have a page string
		$page_str  = preg_match("/page=\d+/", $qs, $m);
		$page= intval(str_replace("page=", "", $m[0])); // if so grab the number
			 
		$activities = $buddy_boss_wall->get_wall_activities($page); // load activities for this page
		
		$nqs = "include=$activities";
		
		
		return $nqs;
	}
// helper fuctions

/* log to screen if in debug mode */
function buddy_boss_log($msg)

{
	global $buddy_boss_debug_log;
	if (!BUDDY_BOSS_WALL_DEBUG) return;
	
	if (is_array($msg) || is_object($msg))
	{ 
	$buddy_boss_debug_log .= " <li> <pre>".print_r($msg, true)."</pre> </li>";
	}
	
	else 
	{
	 $buddy_boss_debug_log.="<li>".$msg. "<li>";
	}

}						  

function buddy_boss_dump_log()
{
	if (!BUDDY_BOSS_WALL_DEBUG) return ;
	global $buddy_boss_debug_log;
	
	echo "<h2> DEBUG LOG </h2>";
	echo "<ul>". $buddy_boss_debug_log."</ul>";
}


require_once(dirname(__FILE__)."/buddy_boss_wall_third_party.php");

?>