<?php 

/* ADMIN OPTIONS */

	function buddy_boss_admin_menu()
		{
			// ask about the position 
			add_menu_page( 'BuddyBoss Settings', 'BuddyBoss', 'manage_options', 'buddy_boss_settings_menu', 'buddy_boss_create_page', get_bloginfo('template_directory').'/_inc/images/buddyboss-admin-icon-16.png', 4 );
		}

add_action('admin_menu', 'buddy_boss_admin_menu');

	function buddy_boss_create_page()
		{
			
		
			if (!empty($_POST['pb'])) 
				{
					$file = $_FILES['logo'];
					
					// var_dump($file);					
					// check if we have an upload
					if ($file['error'] == 4) 
						{
							$msg  = "Please specify the logo";
							$mode = "error";
						}
							else if ($file['error'] == 0)
								{
									// 	process the upload
									
									$ok =  TRUE;
									
									$size  = $file['size'] / 1024; // in KB
									$type  = $file['type'];
									$name =  $file['name'];
									$tmp  =  $file['tmp_name'];
									
									
									if ($size > 150) 
									{
										$msg = "File size must be no more than 150 KB";
										$mode = "error";
										$ok = FALSE;			
									}
									
									if (!in_array($type, array('image/jpeg', 'image/png', 'image/gif')))
										{
										$msg = "Upload error: Make sure your wp-content/uploads folder is writable (<a href='http://codex.wordpress.org/Changing_File_Permissions' target='_blank'>755 or 777</a>) and make sure the image type is JPG, GIF, or PNG.";
										$mode = "error";
										$ok = FALSE;
										}
									
								}
							
							else 
								{
									$msg = "There has been an error uploading the logo. Try again";
									$mode = "error";
									$ok = FALSE;		
								}
	 					
						if ($ok)
							{
								
									
									$upload_dir = wp_upload_dir();
									$path = $upload_dir['path'];
									$rel  = $upload_dir['url'].'/'.$name;
									
									$ok = move_uploaded_file(realpath($tmp), $path."/".$name);
									if ($ok)
										{
											$msg = "Your logo has been uploaded";
											$mode = "updated";
											update_option("buddy_boss_custom_logo", $rel);
											update_option("buddy_boss_custom_logo_file", $path."/".$name);
											
										}
										else 
											{
												$msg = "Error uploading your logo";
											$mode = "error";
											}
								
							}
						
							
				}
				
	if (isset($_POST['del'])) 
	{
		delete_option('buddy_boss_custom_logo');
		$file = get_option('buddy_boss_custom_logo_file');
		unlink($file);
		delete_option('buddy_boss_custom_logo_file');
		
		$msg = "Reverted to the default logo";
		$mode ="updated";
	}
	
	if (isset($_POST['wall_update']))
		{
			if (isset($_POST['wall']))
				{
					
				
			$state  = intval($_POST["wall"]);
			
			if ($state == TRUE && !function_exists("friends_get_alphabetically"))
			{
				$msg = "Wall cannot be turned on if the friends component is inactive";
				$mode = "error";
			} 
				else 
					{
				 update_option("buddy_boss_wall_on",$state );
				 $state_lbl = ($state == TRUE)? "enabled": "disabled";
			 	 $msg = "Wall settings updated: wall is now $state_lbl.";
				 	 $mode = "updated";
				 
				 // if ($state == 1) buddy_boss_wall_on_activate();
				 // if ($state == 0) buddy_boss_wall_on_deactivate();
				  
			 }
			 
			}
			
		}
	
			
			if (!empty($msg))	$message = '<div id="message" style="padding:8px 10px;" class="'.$mode.' below-h2">'. $msg. '</div>';
				
			$current_logo = (get_option("buddy_boss_custom_logo", FALSE) == FALSE) ? get_bloginfo('template_directory').'/_inc/images/logo.jpg' : get_option("buddy_boss_custom_logo");


			$wall_on_status = (get_option("buddy_boss_wall_on", -1) == TRUE && function_exists("friends_get_alphabetically") == TRUE) ? "checked": "";
			$wall_off_status = (get_option("buddy_boss_wall_on", -1) ==FALSE)? "checked": "";
			
			$buddyboss_edit_icon = get_bloginfo('template_directory').'/_inc/images/buddyboss-edit-icon-32.png';

			 
			//echo get_option("buddy_boss_wall_on");
				
			$html = <<<EOF
			
			<div class="wrap" style="padding-top:5px;">
			
				<img alt="BuddyBoss Theme Settings" src="$buddyboss_edit_icon" style="float:left;margin:7px 8px 0 5px;"/>
				<h2>BuddyBoss Theme Settings</h2>
				<p style="padding:0 0 10px 5px">Read the <a href="http://www.buddyboss.com/instructions/" target="_blank">setup instructions</a> to get started. Thanks for purchasing BuddyBoss!</p>
				
				$message
				
				<div id="dashboard-widgets-wrap">
				<div id="dashboard-widgets" class="metabox-holder">
				
		
							<div class="postbox-container" style="width:69%;">
							<div id="normal-sortables" class="meta-box-sortables ui-sortable">			
										<div class="postbox">
											<h3 style="cursor:default"><span>Logo &mdash; appears in header and login page</span></h3>		
											<div class="inside">
												
												<h4>Current Logo</h4>			 
													<img style="border:1px solid #ccc" src="$current_logo">
										
												<h4>Upload New Logo</h4>											
													<form enctype="multipart/data" method="post">
													<input type="file" name="logo"></input>
													<input class="button-primary" type="submit" name="pb" value="Upload" />
													<input class="button-secondary" type="submit" name="del" value="Revert to default"/>
													<p style="color:#777">Logo should be no more than 87px tall and 500px wide. Smaller dimensions are okay.</p>
													<p style="color:#777"><strong>If multisite is enabled:</strong> Go to <em>Network Admin</em> (top right), then click <em>Settings</em>. Scroll down to <em>Upload Settings</em> and make sure "Images" is checked under <em>Media upload buttons</em>.</p>
																					
											</div><!-- end .inside -->
										</div><!-- end .postbox -->
										
										<div class="postbox">
											<h3 style="cursor:default"><span>Profile Wall Component</span></h3>
											<div class="inside">
												<p style="padding:7px 10px;background-color:#fff;border:1px solid #dfdfdf;border-radius:3px;-moz-border-radius:3px;-webkit-border-radius:3px">Wall Component: <input type="radio" name="wall" value="1" $wall_on_status> Enabled 
												<input type="radio" name="wall" value="0" $wall_off_status > Disabled 
												<input class="button-secondary" type="submit" name = "wall_update" value="Update">
												</p>
												<p style="color:#777"><strong>Activity Streams</strong> and <strong>Friends</strong> need to first be enabled, under <em>BuddyPress > Component Setup</em>.</p>
												<p style="color:#777"><strong>Important:</strong> You will need to click the "Update" button when first installing the theme to enable the Wall Compontent.</p>
												</form>
											</div><!-- end .inside -->
										</div><!-- end .postbox -->
							</div>
							</div><!-- end .postbox-container -->
										
							
							
							<div class="postbox-container" style="width:30%;">
							<div id="normal-sortables" class="meta-box-sortables ui-sortable">
									<div class="postbox">
										<h3 style="cursor:default">Theme Support</h3>
										<div class="inside">
												<ul style="padding:10px 0 6px;">
													<li><a style="text-decoration:none;" href="http://www.buddyboss.com/instructions/" target="_blank">Setup Instructions</a></li>
													<li><a style="text-decoration:none;" href="http://www.buddyboss.com/faq/" target="_blank">Frequently Asked Questions</a></li>
													<li><a style="text-decoration:none;" href="http://www.buddyboss.com/plugins/" target="_blank">Recommended Plugins</a></li>
													<li><a style="text-decoration:none;" href="http://www.buddyboss.com/updating/" target="_blank">How to Update</a></li>
													<li><a style="text-decoration:none;" href="http://www.buddyboss.com/release-notes/" target="_blank">Current Version &amp; Release Notes</a></li>
													<li><a style="text-decoration:none;" href="http://www.buddyboss.com/forum/" target="_blank">Support Forums</a></li>
												</ul>
										</div><!-- end .inside -->
									</div><!-- end .postbox -->
							</div>
							</div><!-- end .postbox-container -->
									 									
					
					<div class="clear"></div>									
									
				</div><!-- end #dashboard-widgets -->
				</div><!-- end #dashboard-widgets-wrap -->
				
			</div><!-- end .wrap -->
			<div class="clear"></div>
			
EOF;
			echo $html;				
		}
?>